<?php

 /*************************************************************
 * Convert config file to XML format. CN=Monitor 1.x -> 2.x
 *************************************************************/

$WWWDIR  = dirname(__FILE__)."/../www";
$CONFDIR = dirname(__FILE__)."/../config";
$xmlConfigFile = $CONFDIR."/config.xml";
$oldConfigFile = $CONFDIR."/config.php.rpmsave";

if(!file_exists($oldConfigFile)) {
  echo "Old configuration file: ".$oldConfigFile." does not exist\n";
  exit(1);
}

require $oldConfigFile;
require $WWWDIR."/functions/config_functions.php";
require $WWWDIR."/phpfile/file_class.php";

// setup file logger
$oFile = new File();

if(!empty($CONFIG["general"]["xml"])) {
  echo "Seems to be the new config file as the XML option exist.\n";
  echo "Convertion not possible...\n";
  exit(0);
}

echo "\n";
echo "Converting file config.php.rpmsave to config.xml\n";
echo "\n";

$newConfig = "";

$newConfig .= "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
$newConfig .= "<cnmonitor>\n";

// general keys
if(empty($CONFIG["general"])) {
  $newConfig .= "  <general>\n";
  $newConfig .= "    <language>en</language>\n";
  $newConfig .= "    <environment>\n";
  $newConfig .= "    </environment>\n";
  $newConfig .= "  </general>\n";
}
else {
  $generalKeys = array_keys($CONFIG["general"]);
  $newConfig .= "  <general>\n";
  for($i = 0; $i < count($generalKeys); $i++) {
    if($generalKeys[$i] == "language") {
      $newConfig .= "    <language>".$CONFIG["general"]["language"]."</language>\n";
    }
    if($generalKeys[$i] == "stylesheet") {
      $newConfig .= "    <stylesheet>".$CONFIG["general"]["stylesheet"]."</stylesheet>\n";
    }
    if($generalKeys[$i] == "db") {
      $dbKeys = array_keys($CONFIG["general"]["db"]);
      $newConfig .= "    <database>\n";
      for($j = 0; $j < count($dbKeys); $j++) {
        $newConfig .= "        <".$dbKeys[$j].">".$CONFIG["general"]["db"][$dbKeys[$j]]."</".$dbKeys[$j].">\n";
      }
      $newConfig .= "    </database>\n";
    }

    if($generalKeys[$i] == "env") {
      $dbKeys = array_keys($CONFIG["general"]["env"]);
      $newConfig .= "    <environment>\n";
      for($j = 0; $j < count($dbKeys); $j++) {
        $newConfig .= "        <".$dbKeys[$j].">".$CONFIG["general"]["env"][$dbKeys[$j]]."</".$dbKeys[$j].">\n";
      }
      $newConfig .= "    </environment>\n";
    }
  }
  $newConfig .= "  </general>\n";
} // general section exists

// Environments
for($i = 0; $i < count($CONFIG["env"]); $i++) {
  $newConfig .= "  <environment>\n";

  $envKeys = array_keys($CONFIG["env"][$i][0]);

  for($j = 0; $j < count($envKeys); $j++) {
    if(strpos($envKeys[$j], ":") !== FALSE) {
      echo "\n- Key: ".$envKeys[$j]." can not be moved to new config file.\nConsult documentation\n";
    }
    else {
      $newConfig .= "    <".$envKeys[$j].">".$CONFIG["env"][$i][0][$envKeys[$j]]."</".$envKeys[$j].">\n";
    }
  }

  for($j = 1; $j < count($CONFIG["env"][$i]); $j++) {
    $envKeys = array_keys($CONFIG["env"][$i][$j]);

    $newConfig .= "    <server>\n";
    for($k = 0; $k < count($envKeys); $k++) {
      if(strpos($envKeys[$k], ":") !== FALSE) {
        echo "\n- Key: ".$envKeys[$k]." can not be moved to new config file.\nConsult documentation\n";
      }
      else {
        $newConfig .= "      <".$envKeys[$k].">".$CONFIG["env"][$i][$j][$envKeys[$k]]."</".$envKeys[$k].">\n";
      }
    }
    $newConfig .= "    </server>\n";
  }

  $newConfig .= "  </environment>\n"; 
}


$newConfig .= "</cnmonitor>\n";

$oFile->write($xmlConfigFile, $newConfig);

echo "\n";
echo "-------------------------------------------------------------\n";
echo "Configuration converted to XML format\n";
echo "  New Configuration file: ".$xmlConfigFile."\n";
echo "  Old Configuration file: ".$oldConfigFile."\n";
echo "  Configuration template: ".$xmlConfigFile.".template\n";
echo "";
echo "Please verify and test your configuration!\n";
echo "Consult installation documentation for more information.\n";
echo "-------------------------------------------------------------\n";
echo "\n";

echo "\n";
?>
