<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */

 /*************************************************************
 * Create summary of collected data
 * In order to use this functionality:
 * - Make sure you have php cli installed
 * - Configure database to use in config.php
 * - Schedule this file:
 *   cd <file location>;php collectsummary.php
 *************************************************************/

$WWWDIR  = dirname(__FILE__)."/../www";
$CONFDIR = dirname(__FILE__)."/../config";
require $CONFDIR."/config.php";
require $WWWDIR."/functions/config_functions.php";
require $WWWDIR."/functions/network_functions.php";
require $WWWDIR."/phpfile/file_class.php";
require $WWWDIR."/phpldap/ldap_class.php";
require $WWWDIR."/functions/ldap_functions.php";
require $WWWDIR."/functions/sql_functions.php";
require $WWWDIR."/functions/mail_functions.php";
require $WWWDIR."/functions/image_functions.php";
require $WWWDIR."/functions/collect_functions.php";

// by default run todays date - 1
// this is to be support cron daily tasks which usually is run at 04:00
if(empty($argv[1])) {
  $dateTimestamp = strtotime("-1 day");
}
else {
  $dateTimestamp = strtotime(trim($argv[1]));
  if(empty($dateTimestamp)) {
    echo "Failed using input date: ".$argv[1]."\n";
    echo "Usage : ".$argv[0]." \"<YYYY-mm-dd> where dd is the last day of the month\"\n";
    exit(1);
  }
}

// only create summary of a specific option
if(empty($argv[2])) {
  $operations = Array("ent_sent","byte_sent","tot_con","search",
                      "add","modify","modifyrdn","remove",
                      "in","anon_bind","unauth_bind","simple_bind",
                      "strong_bind","error","compare","exec_time");
}
else {
  $operations = Array($argv[2]);
}

// get start date (todays date - one day)
$datestart = date("Y-m", $dateTimestamp)."-01 00:00:00";
$datestartwithouttime = date("Y-m", $dateTimestamp)."-01";
$dateend = date("Y-m-d", $dateTimestamp)." 23:59:59";
echo $datestart."-".$datestartwithouttime."-".$dateend."\n";

// setup file logger
$oFile = new File();
$logFileName = getTempFileName("collectsummary");
$pidFileName = getTempFileName("collectsummary_pid");
$currentTime = date("Y-m-d H:i:s");

// pausetime in milliseconds
$pauseTime = 1;

removeTempFileName($logFileName);
$logStr  = "Start creating summary (cn=monitor)\n";
$logStr .= "-------------------------------------------------\n";
addToLogger($logStr, $oFile, $logFileName);

// Verify that we have a database Connection
verifyDatabaseConnection($oFile, $logFileName);

// Verify PID file exist
verifyPIDFileExist($pidFileName, $oFile, $logFileName, "collectsummary");

/******************************************************************************
* Checks completed. Script starts here!
******************************************************************************/
$oFile->append($pidFileName, "Started: ".$currentTime);

$env =  getEnvironments();
// list all environments
for($i = 0; $i < count($env); $i++) {
  // log header for this environment
  $logStr = "";
  $logStr .= "Environment: ".$i." ) ".$env[$i][1]."\n";
  $logStr .= "-------------------------------------------------\n";

  // Log
  addToLogger($logStr, $oFile, $logFileName);

  $servers =  getServers($env[$i][0]);
  for($j = 0; $j < count($servers); $j++) {
    $currentServer = trim($servers[$j][1]);

    addToLogger($j." ) ".$currentServer."\n", $oFile, $logFileName);

    for($k = 0; $k < count($operations); $k++) {
      $graphdata = updateDatabaseGraphData(array($currentServer), $operations[$k], $datestart, $dateend, false, false);
      // average value for exec_time
      if($operations[$k] == "exec_time") {
        $summaryvalue = returnAverageValue($graphdata);
      }
      else {
        // create summary for other values
        $summaryvalue = returnSummaryValue($operations[$k], $graphdata);
      }
      addToLogger($j." ) ".$operations[$k]." - Summary Value: ".$summaryvalue."\n", $oFile, $logFileName);
      
      if($summaryvalue) {
        // finally save this value to database
        setSummary($currentServer, $datestartwithouttime, $operations[$k], $summaryvalue);
        addToLogger($j." ) ".$operations[$k]." - Value Stored to db\n", $oFile, $logFileName);
      }
      else {
        addToLogger($j." ) ".$operations[$k]." - Value NOT Stored to db as it is empty\n", $oFile, $logFileName);
      }
      sleep($pauseTime);
    }
  } // for each server
  addToLogger("\n\n", $oFile, $logFileName);
} // for each environment

// Clean up database
removeOldCollectedData();
// Clean up not used files
removeOldTempFiles();


removeTempFileName("collectsummary_pid");
addToLogger("Completed!\n\n", $oFile, $logFileName);

?>
