<?php
  /*
    Copyright (C) 2009-2012 Andreas Andersson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
  */
  
 /*************************************************************
 * Collect Data to Relational Database for Historical Events
 * In order to use this functionality:
 * - Make sure you have php cli installed
 * - Configure database to use in config.php
 * - Schedule this file:
 *   cd <file location>;php collectdb.php
 *************************************************************/

$WWWDIR  = dirname(__FILE__)."/../www";
$CONFDIR = dirname(__FILE__)."/../config";
require $CONFDIR."/config.php";
require $WWWDIR."/functions/config_functions.php";
require $WWWDIR."/functions/network_functions.php";
require $WWWDIR."/phpfile/file_class.php";
require $WWWDIR."/phpldap/ldap_class.php";
require $WWWDIR."/functions/ldap_functions.php";
require $WWWDIR."/functions/sql_functions.php";
require $WWWDIR."/functions/mail_functions.php";
require $WWWDIR."/objects/monitorobject.php";
require $WWWDIR."/objects/snmpobject.php";
require $WWWDIR."/objects/querytimeobject.php";
require $WWWDIR."/objects/serverobject.php";
require $WWWDIR."/functions/collect_functions.php";

$runEnvironment = null;
$optionalHash = "";
// By default run all environments
// By setting argument ID 1 you select to run a specific environment by name
if(!empty($argv[1])) {
  $runEnvironment = $argv[1];
  $optionalHash = hash("md5", $argv[1]);
}

// try to connect to port three times to avoid temporary network glitches
function socketOpenWithRetries($servername, $port) {
  for($i = 0; $i < 3; $i++) {
    if(socketOpen($servername, $port)) {
      return true;
    }
    sleep(1);
  }
  return false;
}

// setup file logger
$oFile = new File();
$tempFileName = "collectdb".$optionalHash;
$logFileName = getTempFileName($tempFileName);
$pidFileName = getTempFileName($tempFileName."_pid");
$currentTime = date("Y-m-d H:i:s");
// this date can be used for unavailable purposes
// as it is a value of current date only one message / day will be set
$datewithouttime = date("Y-m-d");

removeTempFileName("collectdb");
$logStr  = "Start collecting Data (cn=monitor)\n";
$logStr .= "Logfile: ".$logFileName."\n";
$logStr .= "-------------------------------------------------\n";
addToLogger($logStr, $oFile, $logFileName);

// Verify that we have a database Connection
verifyDatabaseConnection($oFile, $logFileName);

// Verify PID file exist
verifyPIDFileExist($pidFileName, $oFile, $logFileName, "collectdb");

/******************************************************************************
* Checks completed. Script starts here!
******************************************************************************/
$oFile->append($pidFileName, "Started: ".$currentTime);

if(!is_null($runEnvironment)) {
  $selectedEnvironment = getEnvironmentId($runEnvironment);
  if(empty($selectedEnvironment)) {
    addToLogger("Specified Environment Not found: \"$runEnvironment\"\nExiting...\n\n", 
                $oFile, $logFileName);
    removeTempFileName($pidFileName);
    exit(1);
  }
  $collectStartIndex = $selectedEnvironment[0];
  $collectEndIndex = $selectedEnvironment[0] + 1;
  $env[$collectStartIndex][0] = $selectedEnvironment[0];
  $env[$collectStartIndex][1] = $runEnvironment;
}
else {
  // default get all environments
  $env =  getEnvironments();
  $collectStartIndex = 0;
  $collectEndIndex = count($env);
}
addToLogger("Collect Start Index : ".$collectStartIndex."\n", $oFile, $logFileName);
addToLogger("Collect End Index   : ".$collectEndIndex."\n\n", $oFile, $logFileName);

// list all or selected environment
for($i = $collectStartIndex; $i < $collectEndIndex; $i++) {
  // log header for this environment
  $logStr = "";
  $logStr .= "Environment: ".$i." ) ".$env[$i][1]."\n";
  $logStr .= "-------------------------------------------------\n";

  // Log
  addToLogger($logStr, $oFile, $logFileName);

  $servers =  getServers($env[$i][0]);
  for($j = 0; $j < count($servers); $j++) {
    $currentServer = trim($servers[$j][1]);
    $port = getPort($currentServer);

    addToLogger($j." ) ".$currentServer."\n", $oFile, $logFileName);

    $nocollect = getConfigValue("nocollect", $servers[$j][2], $servers[$j][0]); 

    // ok to collect data
    if(empty($nocollect)) {
      if(socketOpenWithRetries($currentServer, $port)) {
        $oServer = setServer($currentServer);
        // get monitor object
        $executionTime = $oServer->getExecutionTime();
        // monitor
        $monitor = setMonitor($currentServer);
        setMonitorHistory($monitor, $currentTime, $executionTime);
        // snmp
        $snmp = setSnmp($currentServer);
        setSnmpHistory($snmp, $currentTime);
        removeTempFileName("server_".$currentServer);
      }
    }
    else {
        // collect of data disabled
        addToLogger($j." ) Collect of Data disabled\n", $oFile, $logFileName);
    }
  }
  addToLogger("\n\n", $oFile, $logFileName);
}

removeTempFileName($tempFileName."_pid");
addToLogger("Completed!\n\n", $oFile, $logFileName);

?>
