var should = require('should'),
    url = require('url'),
    child_process = require('child_process'),
    http = require('http'),
    fs = require('fs'),
    daemon = false,
    pidfile = process.cwd() + '/test/api-gateway.pid',
    proxy = {};
    

describe('API Daemon', function() {

    var goodBody = '{test:1234}',
        errorBody = '{error:"Invalid Method"}';

    /*
     * Before running the tests, start up
     * - the proxy daemon
     * - an API with all options enabled
     * - an API with all options disabled
     */

    before(function(done) {

        process.env.API_LIB = process.cwd() + '/lib';
        process.env.API_CONFIG = process.cwd() + '/etc/api-gateway/apilist';
        process.env.API_REDIRECTOR_PORT = 8080;
        process.env.API_PROXY_PORT = 8443;
        process.env.API_KEY = process.cwd() + '/test/test.key';
        process.env.API_CERT = process.cwd() + '/test/test.crt';
        process.env.API_CA_LIST = process.cwd() + '/test/test.crt';
        process.env.API_PIDFILE = pidfile;
        process.env.API_LOGDIR = process.cwd() + '/var/log/api-gateway';
        process.env.API_LOGFILE = 'api-gateway.log';
        // get the current user and group names
        process.env.API_USER = child_process.spawnSync('id',['-un']).stdout.toString().split('\n')[0];
        process.env.API_GROUP = child_process.spawnSync('id',['-gn']).stdout.toString().split('\n')[0];
        
        try {
            fs.unlinkSync(pidfile);
        } catch (err) {
            if (err.code !== 'ENOENT') {
                throw err;
            }
        }

        daemon = child_process.spawn(process.cwd() + '/api-gateway', [], {
            cwd: process.cwd(),
            env: process.env,
        });
        
/*
        daemon.stdout.on('data', function (data) {
          console.log('DAEMON-OUT: ' + data);
        });
*/
        daemon.stderr.on('data', function (data) {
          console.error('DAEMON-ERR: ' + data);
        });

        // give daemon 1 second to get started
        setTimeout(done, 1000);
    });
    
    it('should create a pid file', function (done) {
        fs.stat(process.env.API_PIDFILE, function (err, statbuf) {
            if (err) {
                throw new Error('Daemon did not create PID file:', err.msg);
            }
            done();
        });
    });
    
    it('should create a pid file, and have the right pid in the pid file', function (done) {
        fs.readFile(process.env.API_PIDFILE, function (err, data) {
            if (err) {
                throw err;
            }
            data.toString().should.equal(daemon.pid + '\n');
            done();
        });
    });
    
    // last test!
    it('should remove the pid file when it exits', function (done) {
        // add a handler for the daemon exit event
        daemon.on('exit', function (code) {
            (function () {
                fs.unlinkSync(pidfile);
            }).should.throw(/ENOENT/);
            done();
        });

        // kill the daemon
        daemon.kill('SIGTERM');
    });

});    
