/*
 * Reject the request if OAuth is required, and no OAuth header is defined
 * Does not yet check the validity of the token
 */

exports.oauthTokenCheck = function oauthTokenCheck(req, res, next) {

  var hasOAuthToken = (req.headers.authorization &&
                       req.headers.authorization.search(/^bearer\s+(\S+)$/i) !== -1);

  if (req.api.proxy.requireOAuthToken && !hasOAuthToken) {
    res.sendError(401, 'OAuth Authorization Token is required by this API');
  } else {
    next();
  }
};
