/*
 * Example API Configuration
 *
 * Add a new key & object to apiList to define a new API
 * The key should be the base API endpoint on the gateway
 */
exports.apiList = {
    "/five/v1": {
        description: "Return 5 digit number",
        proxy: {
            jsonp: true,           // allow JSONP Wrapping
            methodOverride: false  // disallow method overrides
        },
        backend: {
            // where the real API lives
            hostname: "stanford-api-test.s3-us-west-2.amazonaws.com",
            port: 443,
            protocol: "https",
            pathname: "/api/v1"
        }
    },
    "/profiles/v1": {
        description: "CAP API",
        proxy: {
            jsonp: false,
            methodOverride: false
        },
        backend: {
            hostname: "irt-dev.stanford.edu",
            port: 443,
            protocol: "https",
            pathname: "/cap-api/api/profiles/v1"
        }
    }
};

