# API Gateway

This is a basic RESTful API Gateway, built on top of [http-proxy](https://github.com/nodejitsu/node-http-proxy) and [connect middleware](https://github.com/senchalabs/connect).

## Debian Package Build

I converted this to a Debian native package and made some changes that were necessary
to get it to build. Build in the `debian` branch.

## Intial Setup

Run

        npm install

in the top level directory to install all the dependencies

## Extra Features

While these features are needed yet, I've added them as examples.

### JSONP Wrapper

If an API request includes a callback=fn query parameter, lib/jsonpWrapper will wrap the JSON response from the API with that function.  This can be enabled / disabled per-API by setting proxy.jsonp to true / false in the API configuration.

### Method Override

Similar to JSONP Wrapper, the proxy will change the method for a request if

* the original method is POST
* an override is included in the request
* proxy.methodOverride is true in the API's configuration

There are 3 headers that can be used to override the method:

#### X-HTTP-Method-Override

        POST /apithing/v1/container/resource HTTP/1.1
        X-HTTP-METHOD-OVERRIDE: DELETE
        ...

#### X-HTTP-Method


        POST /apithing/v1/container/resource HTTP/1.1
        X-HTTP-METHOD: DELETE
        ...

#### X-Method-Override

        POST /apithing/v1/container/resource HTTP/1.1
        X-METHOD-OVERRIDE: DELETE
        ...

Clients that cannot set headers can also use the _method parameter in the query string:

        POST /apithing/v1/container/resource?_method=DELETE HTTP/1.1
        ...


# Tests

Running

        npm test

to run tests on jsonpWrapper, methodOverride and the proxy.
