/*
 * override the request method with the one specified in a header or query parameter, if it's allowed by configuration
 *
 */

var url = require('url');

exports.methodOverride = function methodOverride(req, res, next) {
  var tmpUrl,
      override =
        req.headers['x-http-method'] ||
        req.headers['x-http-method-override'] ||
        req.headers['x-method-override'] ||
        req.query._method;

  if (!override) {
    // nothing to do
    next();
  } else {

    // save the override method
    override = override.toUpperCase();

    // clean up headers
    delete req.headers['x-http-method'];
    delete req.headers['x-http-method-override'];
    delete req.headers['x-method-override'];

    // clean up the URL if method was passed in the _method parameter,
    if (req.query._method) {
      tmpUrl = url.parse(req.url);
      tmpUrl.query = req.query;
      delete tmpUrl.query._method;
      delete tmpUrl.search;
      req.url = url.format(tmpUrl);
      req.query = tmpUrl.query;
    }

    if (!req.api.proxy.methodOverride) {
      // not allowed by configuration
      res.sendError(400, 'Method override not supported for this API');
    } else if (req.method !== 'POST') {
      // not a POST, so reject it
      res.sendError(405, 'Method override only supported for POST');
    } else {
      // replace the method
      req.origMethod = req.method;
      req.method = override;
      next();
    }
  }
};
