/*
 * Support for pulling the appropriate API data from the API configuration,
 * which is then added to the request
 */

var url = require('url');


module.exports = function apis (apiList) {

  var _apiList = apiList,
      that = {};

  /*
   * find the API configuration by path
   * and return it
   */

  that.getAPI = function getAPI(path) {
    var extra = [],
        urlParts = url.parse(path),
        splitPath = urlParts.pathname.split(/\/+/).filter(function (s) { return s.length; }),
        api = false,
        apiPath = '';

    // search for the longest path that matches an API
    while (splitPath.length > 0 && !api) {
      apiPath = '/' + splitPath.join('/');
      if (_apiList.hasOwnProperty(apiPath)) {
        api = _apiList[apiPath];
      } else {
        extra.unshift(splitPath.pop());
      }
    }

    // augment the api object

    if (api) {
      api.origUrl = urlParts;
      api.apiPath = apiPath;
      api.extraPath = (extra.length > 0) ? '/' + extra.join('/')  : '';
      api.extra = extra;
    }

    return api;
  };


  // return a function that can augment the request object
  // with API data
  that.addAPIDetails = function addAPIDetails(req, res, next) {
    var api = that.getAPI(req.url),
        reqUrl = url.parse(req.url),
        proxyUrl;

    if (api) {
      req.api = api;
      req.origUrl = req.url;
      proxyUrl = {
        pathname: api.backend.pathname + api.extraPath,
        search: reqUrl.search
      };

      req.url = url.format(proxyUrl);
      next();
    } else {
      res.sendError(404, 'API Not Found');
    }
  };

  return that;
};

