I've mostly followed Russ' instructions for a [Combined Debian and
Upstream](http://www.eyrie.org/~eagle/notes/debian/git.html#combine)
package.

# Branches

Code development is done on the _master_ branch, and packaging is done
on the _debian_ branch. The other two branches - _pristine-tar_ and
_upstream_ are used by _git-import-orig, and should not be used directly.

# NVM

NVM is tool for managing multiple versions of node and npm. If you're
using NVM (probably if you're doing development on a Mac), then make
sure you run _nvm use_ in the base directory before testing, to ensure
that you're running the right version of node:

    % nvm use
    Found .nvmrc files with version <v0.8.21>
    Now using node v0.8.21

(There's an _.nvmrc_ file in the base directory that specifies the
correct version of node)

You should also remove node_modules and rebuild
it, since the _node-syslog_ package includes some native code that
needs to be rebuilt for specific versions of node:

    % rm -rf node_modules
    % npm install --loglevel warn

    > node-syslog@1.1.7 install /Users/swl/src/api/api-gateway/node_modules/node-syslog
    > node-gyp rebuild

      CXX(target) Release/obj.target/syslog/syslog.o
    ...

# Making changes

Checkout the master branch, and make the code (and test) updates. If
you add new files anywhere other than the _lib_ directory, add them to
the SOURCES definition in _Makefile_.

Add new dependencies for the gateway daemon to the _dependencies_
section in _package.json_. If you need to add more node-based
development and testing helpers, add those to the _devDepencies_
section in _package.json_.

Install all the node dependencies with

    % npm install

Run the tests with

    % npm test

Test for code style issues with

    % make checkstyle

Note: test and checkstyle use the mocha, instanbul and jshint packages
installed under node_modules

Once all the tests pass, and checkstyle issues have been dealt with,
bump the version number in _package.json_ and commit the changes.

Tag the last commit with release/version, e.g:

    % git tag release/1.0.2

# Building an Updated Debian Package

(While the previous steps can be done on a non-Debian system, the
packaging needs to be done on a system with the same OS and
architecture as the intended target(s). Ensure the Debian build system
has the latest commits to the _master_ branch).

## Create the Distribution Tarball

Still on the master branch, run

    % make distclean dist

to create the distribution tarball - e.g. _api-gateway-1.0.2.tar.gz_.
Copy this to wherever your _git-import_orig_ looks for tarballs - on my
build system it's in _~/tarballs_.

Run

    % git-import-orig ~/path/to/tarball

You should be prompted to confirm the version number, then when the
process is finished you'll be on the _debian_ branch, with a new
_upstream/version_ tag:

    % git-import-orig ~/tarballs/api-gateway-1.0.2.tar.gz
    What is the upstream version? [1.0.2]
    gbp:info: Importing '/home/admin/tarballs/api-gateway-1.0.2.tar.gz' to branch 'upstream'...
    gbp:info: Source package is api-gateway
    gbp:info: Upstream version is 1.0.2
    pristine-tar: committed api-gateway_1.0.2.orig.tar.gz.delta to branch pristine-tar
    gbp:info: Merging to 'debian'
    Switched to branch 'debian'
    Merge made by the 'recursive' strategy.
    gbp:info: Successfully imported version 1.0.2 of /home/admin/tarballs/api-gateway-1.0.2.tar.gz

Now you need to update _debian/changelog_ - you can do this manually,
or use git-dch to get started. I use something like this:

    % git-dch --git-author -R -N 1.0.2-1 -s release/1.0.1 --git-log="release/1.0.1.. master"
    
That means: use my git info (name, email) for the changelog trailer,
mark this as a new release, and version _1.0.2-1_, and import git log
messages since tag _release/1.0.1_. The _--git-log_ option also brings
in log messages from the master branch.

_git-dch_ should put you into an editor so that you can clean up
_changelog_. Once you've saved _changelog_, commit the changes:


    % git commit -m 'Update changelog for 1.0.2-1 release' debian/changelog

Tag the Debian release:

    % git tag debian/1.0.3-1

Finally, build the new package:

    % git-buildpackage

or 

    % git-buildpackage -uc -us

if you don't have a signing key.

